<?php
require_once( 'utility.php' ) ;

function get_image_type_id( $db_host, $db_user, $db_password, $path ) {
    if(($db_connect = pg_connect("host=$db_host dbname=dtasdb port=5432 user=$db_user password=$db_password")) == FALSE) {
        echo "Failed to connect to database\n" ;
        exit( 1 ) ;
    }
    
    debug_print( "PATH: $path\n" ) ;
    
    $result = pg_query_params(
        $db_connect,
        'SELECT key FROM tb_global_setting WHERE value=$1',
        array( "$path" ) ) ;

    $tmp = pg_fetch_array( $result ) ;
    $key = $tmp[ 0 ] ;
    
    $tmp = explode( ".", $key ) ;
    $tmp = explode( "_", $tmp[ 2 ] ) ;
    $id = $tmp[ 1 ] ;
    
    debug_print( "ID: $id\n" ) ;

    pg_close( $db_connect ) ;
    return $id ;
}

function get_available_ip( $ip_usage_fpath, $max ) {
    $ip_in_used = array() ;
    $file = fopen( $ip_usage_fpath, "r" ) ;
    while( ( $line = fgets( $file ) ) != FALSE ) {
		if ( trim( $line ) == "" ) continue;
        $ip = explode( "=", $line ) ;
        array_push( $ip_in_used, trim( $ip[ 1 ] ) ) ;
    }
    fclose( $file ) ;

    # DTAS-00906
    # let ip 1.1.2.1 be reserved ip for sandbox default ip.
    # it will not be dispatched during ip reconfiguring.
    for( $i = 2 ; $i <= $max + 1 ; $i++ ) {
        $conditate_ip = "1.1.2.$i" ;

        if( array_search( $conditate_ip, $ip_in_used ) === FALSE ) {
            return $conditate_ip ;
        }
    }
    
    print_error( array( "no available ip" ), 1 ) ;
}

function configure_sandboxes( $argv ) {
	global $DTASCFG_XML_FILE, $BACKEND;

	$xml = simplexml_load_file( $DTASCFG_XML_FILE ) ;

	$esxi_ip       = chop( $xml->esxi->ip ) ;
	$esxi_username = chop( $xml->esxi->username ) ;
	$esxi_password = $xml->esxi->password ;

	$sc_prefix   = chop( $xml->sandbox_controller->prefix ) ;
	$sc_username = chop( $xml->sandbox_controller->admin_username ) ;
	$sc_password = $xml->sandbox_controller->admin_password ;
	$sc_dir      = chop( $xml->sandbox_controller->ctrl_dir ) ;
    
	$sb_username = chop( $xml->sandbox->admin_username ) ;
	$sb_password = $xml->sandbox->admin_password ;
	$sb_number   = chop( $xml->sandbox->number ) ;
	$sb_default_ip = chop( $xml->sandbox->default_ipaddr ) ;
	$os_start_time = chop( $xml->cli->os_start_time ) ;

    $db_host     = chop( $xml->db->host ) ;
    $db_user     = chop( $xml->db->username ) ;
    $db_password = $xml->db->password ;

	$sc_vmpath_vix = get_vm_vixpath( $esxi_ip, $esxi_username, $esxi_password, $sc_prefix ) ;
	debug_print( "get sc_vmpath_vix: $sc_vmpath_vix" ) ;

	debug_print( "copy \"setup_sbclone_ip.sh\" to sandbox_controller ..." ) ;
	copy_file_to_sc( array(
        'from' => dirname(__FILE__) . "/../setup_sbclone_ip.sh",
        'to'   => "$sc_dir/setup_sbclone_ip.sh"
    ) ) ;

	debug_print( "copy \"setup_internet_connection.sh\" to sandbox_controller ..." ) ;
	copy_file_to_sc( array(
        'from' => dirname(__FILE__) . "/../setup_internet_connection.sh",
        'to'   => "$sc_dir/setup_internet_connection.sh"
    ) ) ;

	debug_print( "copy \"ip.txt\" to sandbox_controller ..." ) ;
	copy_file_to_sc( array(
        'from' => dirname(__FILE__) . "/../ip.txt",
        'to'   => "$sc_dir/ip.txt"
    ) ) ;
        
    ########################################
    # dispatch ip
    ########################################
    $ip_usage_fpath = dirname(__FILE__) . "/../IPUsage" ;
    $sb_added_fpath = $GLOBALS[ "NEW_SB_ADDED_FILE" ] ;
    $lines = file( $sb_added_fpath ) ;
    foreach( $lines as $sb_vmpath ) {
        $sb_vmpath = trim( $sb_vmpath ) ;
		if( $sb_vmpath == "" ) continue ;
        debug_print( "RequestIP: $sb_vmpath" ) ;
        
        $available_ip = get_available_ip(
            $ip_usage_fpath,
            $sb_number ) ;
        debug_print( "AvailableIP: $available_ip" ) ;

		debug_print( "launch \"setup_sbclone_ip.sh\" in sandbox_controller ..." ) ;
		run_program_at_sc_by_ssh( array(
			'program'   => "$sc_dir/setup_sbclone_ip.sh", 
			'arguments' => array(
				$esxi_ip,
				$esxi_username,
				$esxi_password,
				$sb_username,
				$sb_password,
				$sb_vmpath,
				$available_ip,
				$sb_default_ip,
				$os_start_time ) ) ) ;
            
        # update this ip into file "IPUsage"
        exec_command( array(
            "echo \"$sb_vmpath=$available_ip\" >> $ip_usage_fpath" ) ) ;
            
        debug_print( "copy \"setup.log\" from SC to MS and rename it to \"setup_ctrl2.log\" ..." ) ;
		copy_file_from_sc( array(
			'from' => "$sc_dir/setup.log",
			'to'   => dirname(__FILE__) . "/../setup_ctrl2.log"
		) ) ;
    }
    unlink( $sb_added_fpath ) ;
    
    
    ########################################
    # reset isActive = 1 according to file "NewSBGroupInfoESXi"
    ########################################

    # get current sandbox image type count
    $sb_img_type = array() ;
    $new_sb_group_info_path = $GLOBALS[ "NEW_SB_GROUP_INFO_ESXI_FILE" ] ;
    $lines = file( $new_sb_group_info_path ) ;
    foreach( $lines as $line ) {
        $line = trim( $line ) ;
        if( $line == "" ) continue ;
        
        array_push( $sb_img_type, $line ) ;
    }
    
    try {
    
        # get db connection
        $connection = pg_connect( "host=$db_host dbname=dtasdb user=$db_user password=$db_password" ) ;
        if( $connection == false ) {
            throw new Exception( "ConnectToDbFail: host='$db_host', user='$db_user'" ) ;
        }

        # get max sandbox image type id
        if( ( $queryResult = pg_query( $connection,
            "SELECT max(value) FROM tb_global_setting WHERE key LIKE 'configuration.image_type.image_%.id'" ) ) == false ) {

            throw new Exception( pg_last_error() ) ;
        }

        $tmp = pg_fetch_array( $queryResult, 0, PGSQL_NUM ) ;
        $max_sb_type_id = $tmp[ 0 ] ;
        debug_print( "max sandbox images type id: ${max_sb_type_id}" ) ;

        $pathes_vix = file( $GLOBALS[ "NEW_SB_GROUP_INFO_VIX_FILE" ] ) ;
        foreach( $sb_img_type as $index => $path ) {
            $path_vix = $pathes_vix[ $index ] ;
            
            debug_print( "check if exists: $path_vix" ) ;
            
            // verif if exists
            $queryResult = pg_query_params(
                $connection,
                "SELECT key FROM tb_global_setting WHERE key LIKE $1 AND value = $2",
                array( "configuration.image_type.image_%.path", $path ) ) ;
                
            if( $queryResult == false || pg_fetch_all( $queryResult ) == false ) {
                debug_print( "NotExistInDB: $path" ) ;
                
                $max_sb_type_id += 1 ;
                debug_print( "get new sandbox images type id: ${max_sb_type_id}" ) ;
                
                $data_to_be_inserted = array(
                    "configuration.image_type.image_$max_sb_type_id.id"       => $max_sb_type_id,
                    "configuration.image_type.image_$max_sb_type_id.isActive" => "1",
                    "configuration.image_type.image_$max_sb_type_id.name"     => basename( $path, ".vmx" ),
                    "configuration.image_type.image_$max_sb_type_id.path"     => $path,
                    "configuration.image_type.image_$max_sb_type_id.path_vix" => $path_vix,
                    "configuration.image_type.image_$max_sb_type_id.admin_username" => "administrator",
                    "configuration.image_type.image_$max_sb_type_id.admin_password" => "111111" ) ;
                
                foreach( $data_to_be_inserted as $key => $value ) {
                    if( pg_query_params(
                        $connection,
                        "INSERT INTO tb_global_setting VALUES($1,$2)",
                        array( $key, $value ) ) == false ) {

                        throw new Exception( "InsertKeyToDBFail: key=$key, value=$value, Error=" . pg_last_error() ) ;
                    }
                }
            }
            
            else {
                $record = pg_fetch_array( $queryResult, 0, PGSQL_NUM ) ;
                $key = $record[ 0 ] ;
                debug_print( "ExistInDB, key=$key, value=$path" ) ;
                
                # get image_type_id
                $slices = explode( ".", $key ) ;
                if( count( $slices ) != 4 ) {
                    throw new Exception( "UnexpectedFormat: " . $key ) ;
                }
                
                array_pop( $slices ) ;
                $data_to_be_updated = array(
                    join( ".", $slices ) . ".isActive" => "1" ) ;
                    
                foreach( $data_to_be_updated as $key => $value ) {
                    if( pg_query_params(
                        $connection,
                        "UPDATE tb_global_setting SET value=$1 WHERE key=$2",
                        array( $value, $key ) ) == false ) {

                        throw new Exception( "UpdateKeyToDBFail: key=$key, value=$value, Error=" . pg_last_error() ) ;
                    }
                }
            }
        }
    }
    
    catch( Exception $e ) {
        debug_print( "Exception caught: " . $e->getMessage() ) ;
        pg_close( $connection ) ;
        exit( 1 ) ;
    }
    pg_close( $connection ) ;
    

    ########################################
    # regrouping sandbox
    ########################################
    
    # get image_type id
    $sb_path_to_id = array() ;
    foreach( $sb_img_type as $path ) {
        $id = get_image_type_id( $db_host, $db_user, $db_password, $path ) ;
        $sb_path_to_id[ $path ] = $id ;
    }
  
    # get group number we should create
    $sb_group_number = ( count( $sb_img_type ) == 0 ) ?
        0 :
        $sb_number / count( $sb_img_type ) ;
 
    # get current ip usage
    $sb_vmpath_to_ip = array() ;
    $lines = file( $ip_usage_fpath ) ;
    foreach( $lines as $line ) {
        $line = trim( $line ) ;
        if( $line == "" ) continue ;
        
        $tmp    = explode( "=", $line ) ;
        $vmpath = $tmp[ 0 ] ;
        $ip     = $tmp[ 1 ] ;
        $sb_vmpath_to_ip[ $vmpath ] = $ip ; 
    }
    
    # grouping
    $sb_group_to_ip = array() ;
    for( $i = 1 ; $i <= $sb_group_number ; $i++ ) {
        foreach( $sb_img_type as $path ) {
            $id          = $sb_path_to_id[ $path ] ;
            $base_name   = basename( $path, ".vmx" ) ;
            $folder_name = dirname( $path ) ;
            
            $vmpath = "${folder_name}_${i}/${base_name}_${i}.vmx" ;
            $ip     = $sb_vmpath_to_ip[ $vmpath ] ;
            
            $unit = "${id}-${ip}" ;
            isset( $sb_group_to_ip[ "$i" ] ) ?
                $sb_group_to_ip[ "$i" ] .= "," . $unit :
                $sb_group_to_ip[ "$i" ] = $unit ;
        }
    }

    # save current info into database
    foreach( $sb_group_to_ip as $group_num => $list ) {
        $unit = explode( ",", $list ) ;
        foreach( $unit as $u ) {
            $id_ip_array = explode( "-", $u ) ;
            $id = $id_ip_array[ 0 ] ;
            $ip = $id_ip_array[ 1 ] ;
            
            exec_command( array( "$BACKEND insert_configuration_to_db",
                $db_host,
                $db_user,
                $db_password,
                "configuration.sandbox.groups.group_${group_num}.ip_${id}",
                $ip ) ) ;
        }
    }
}

